//
//  TTFont.h
//  GSFontTools
//
//  Created by Georg Seifert on 23.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SFNTReader;
@class TTable;
@class GSXMLWriter;
@protocol SFNTWriter;
@class TTGlyph;

#define TTsfntVersionCFF @"OTTO"
#define TTsfntVersionTrueType @"0100"
#define TTsfntVersionTTCubic @"CUBE"
#define TTsfntVersionAppleTrueType @"true"
#define TTsfntVersionTTC @"ttcf"

@protocol GlyphSet <NSObject>

- (id)glyphForName:(NSString *)glyphName;
- (NSArray *)allKeys;
- (NSArray *)allValues;
- (NSUInteger)count;
@end

@interface TTFont : NSObject {
	NSString *_path;
	NSMutableDictionary *_tables;
	SFNTReader *_reader;
	NSArray *_glyphOrder;
	NSDictionary *_glyph2Index;
	BOOL _disassembleInstructions;
	BOOL _verbose;
	BOOL _ignoreDecompileErrors;
	BOOL _recalcBBoxes;
	NSMutableDictionary *VIDDict;
	NSUInteger last_vid;
	NSMutableDictionary *reverseVIDDict;
	NSDictionary *_reverseGlyphOrderDict;
	NSString *_sfntVersion;
}
@property (retain, nonatomic) NSString *sfntVersion;
@property (retain, nonatomic) NSString *path;
@property (retain, nonatomic) NSMutableDictionary *tables;
@property (retain, nonatomic) NSArray *glyphOrder;
@property (nonatomic) BOOL verbose;
@property (nonatomic) BOOL ignoreDecompileErrors;
@property (nonatomic, assign) BOOL recalcBBoxes;
@property (nonatomic, assign) NSUInteger fontIndex; // for TTC fonts

@property (nonatomic, readonly) NSArray *allKeys;

@property (readonly) SFNTReader *reader;

- (id)initWithPath:(NSString *)path;
- (id)initWithData:(NSData *)data;
- (BOOL)saveFont:(NSString *)savePath error:(NSError **)error;
- (NSData *)fontDataError:(NSError **)error;
- (void)saveToXML:(NSString *)XMLPath;
- (void)saveToXML:(NSString *)XMLPath writeTables:(NSArray *)writeTables skipTables:(NSArray *)skipTables splitTables:(BOOL)splitTables disassembleInstructions:(BOOL)disassembleInstructions;
- (BOOL)isLoaded:(NSString *)tag;
- (BOOL)has_key:(NSString *)tag;
//- (NSString *)sfntVersion;
- (NSUInteger)count;
- (id)tableForKey:(NSString *)key;
- (void)setTable:(TTable *)table forKey:(NSString *)tag;
- (void)removeTableForKey:(NSString *)tag;
- (NSArray *)glyphNames;
- (NSArray *)glyphNames2;
- (NSString *)glyphNameAtIndex:(NSUInteger)glyphIndex;
- (NSUInteger)indexOfGlyphForName:(NSString *)glyphName;
- (BOOL)_writeTable:(NSString *)tag writer:(id<SFNTWriter>)writer done:(NSMutableArray *)done error:(NSError **)error;
- (NSData *)tableDataForKey:(NSString *)tag error:(NSError **)error;
- (id<GlyphSet>)glyphSet;
- (NSUInteger)numFonts;
- (NSDictionary *)reverseGlyphToIndexMap:(BOOL)rebuild;

+ (NSString *)stringFromSfntVersionChar:(char *)sfntVersion;
@end

Class getTableClass(NSString *tag);
